<?php $__env->startSection('title',translate('shop_Page')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <?php if($shopInfoArray['id'] != 0): ?>
        <meta property="og:image" content="<?php echo e($shopInfoArray['image_full_url']['path']); ?>"/>
        <meta property="og:title" content="<?php echo e($shopInfoArray['name']); ?> "/>
        <meta property="og:url" content="<?php echo e(route('shopView',[$shopInfoArray['id']])); ?>">
    <?php else: ?>
        <meta property="og:image" content="<?php echo e($web_config['fav_icon']['path']); ?>"/>
        <meta property="og:title" content="<?php echo e($shopInfoArray['name']); ?> "/>
        <meta property="og:url" content="<?php echo e(route('shopView',[$shopInfoArray['id']])); ?>">
    <?php endif; ?>

    <?php if($shopInfoArray['id'] != 0): ?>
        <meta property="twitter:card" content="<?php echo e($shopInfoArray['image_full_url']['path']); ?>"/>
        <meta property="twitter:title" content="<?php echo e(route('shopView',[$shopInfoArray['id']])); ?>"/>
        <meta property="twitter:url" content="<?php echo e(route('shopView',[$shopInfoArray['id']])); ?>">
    <?php else: ?>
        <meta property="twitter:card" content="<?php echo e($web_config['fav_icon']['path']); ?>"/>
        <meta property="twitter:title" content="<?php echo e(route('shopView',[$shopInfoArray['id']])); ?>"/>
        <meta property="twitter:url" content="<?php echo e(route('shopView',[$shopInfoArray['id']])); ?>">
    <?php endif; ?>

    <meta property="og:description" content="<?php echo e($web_config['meta_description']); ?>">
    <meta property="twitter:description" content="<?php echo e($web_config['meta_description']); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <?php ($decimalPointSettings = getWebConfig(name: 'decimal_point_settings')); ?>

    <div class="container py-4 __inline-67">
        <div class="rtl">
            <div class="bg-white __shop-banner-main">
                <?php if($shopInfoArray['id'] != 0): ?>
                    <img class="__shop-page-banner" alt=""
                         src="<?php echo e(getStorageImages(path: $shopInfoArray['banner_full_url'], type: 'wide-banner')); ?>">
                <?php else: ?>
                    <?php ($banner=getWebConfig(name: 'shop_banner')); ?>
                    <img class="__shop-page-banner" alt=""
                         src="<?php echo e(getStorageImages(path: $banner, type: 'wide-banner')); ?>">
                <?php endif; ?>
                <?php echo $__env->make('web-views.seller-view.shop-info-card', ['displayClass' => 'd-none d-md-block max-width-500px'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            </div>
        </div>

        <?php echo $__env->make('web-views.seller-view.shop-info-card', ['displayClass' => 'd-md-none border mt-3'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form method="POST" action="<?php echo e(url()->current()); ?>" class="product-list-filter">
            <input hidden name="offer_type" value="<?php echo e($data['offer_type']); ?>">
            <input hidden name="data_from" value="<?php echo e(request('data_from')); ?>">
            <input hidden name="category_id" value="<?php echo e(request('category_id')); ?>">
            <input hidden name="brand_id" value="<?php echo e(request('brand_id')); ?>">

            <?php echo csrf_field(); ?>
            <?php echo $__env->make('web-views.products.partials._product-list-header', [
                    'pageProductsCount' => $products->total(),
                    'searchBarSection' => true,
                    'sortBySection' => true,
                    'showProductsFilter' => true,
                    'shopViewPageHeader' => true,
            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="py-3 mb-2 mb-md-4 rtl __inline-35" dir="<?php echo e(session('direction')); ?>">
                <div class="row">
                    <aside class="col-lg-3 hidden-xs col-md-3 col-sm-4 SearchParameters __search-sidebar" id="SearchParameters">
                        <div class="cz-sidebar __inline-35 p-4 overflow-hidden" id="shop-sidebar">
                            <div class="cz-sidebar-header p-0">
                                <button class="close ms-auto fs-18-mobile" type="button" data-dismiss="sidebar" aria-label="Close">
                                    <i class="tio-clear"></i>
                                </button>
                            </div>

                            <div class="pb-0 shop-sidebar-scroll">
                                <div class="d-flex gap-3 flex-column">
                                    <h5 class="fs-16 font-weight-bold m-0"><?php echo e(translate('Filter_By')); ?></h5>
                                    <hr>
                                    <?php echo $__env->make('web-views.products.partials._filter-product-type', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php echo $__env->make('web-views.products.partials._filter-product-sort', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php echo $__env->make('web-views.products.partials._filter-product-price', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php echo $__env->make('web-views.products.partials._filter-product-categories', [
                                        'productCategories' => $categories,
                                        'dataFrom' => 'shop-view',
                                        'shopSlug' => ($shopInfoArray['id'] != 0 ? $shopInfoArray['id'] : 0),
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php echo $__env->make('web-views.products.partials._filter-product-brands', [
                                        'productBrands' => $activeBrands,
                                        'dataFrom' => 'shop-view',
                                        'shopSlug' => ($shopInfoArray['id'] != 0 ? $shopInfoArray['id'] : 0),
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php echo $__env->make('web-views.products.partials._filter-publishing-houses', [
                                        'productPublishingHouses' => $shopPublishingHouses,
                                        'dataFrom' => 'shop-view',
                                        'shopSlug' => ($shopInfoArray['id'] != 0 ? $shopInfoArray['id'] : 0),
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php echo $__env->make('web-views.products.partials._filter-product-authors', [
                                        'productAuthors' => $digitalProductAuthors,
                                        'dataFrom' => 'shop-view',
                                        'shopSlug' => ($shopInfoArray['id'] != 0 ? $shopInfoArray['id'] : 0),
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>

                        </div>
                        <div class="sidebar-overlay"></div>
                    </aside>

                    <section class="col-lg-9">
                        <div class="row" id="ajax-products-view">
                            <?php echo $__env->make('web-views.products._ajax-products', ['products' => $products], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </section>
                </div>
            </div>

        </form>

    </div>


    <span id="shop-sort-by-filter-url" data-url="<?php echo e(url('/')); ?>/shopView/<?php echo e($shopInfoArray['id']); ?>"></span>

    
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog"
         aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header bg-faded-info">
                    <h5 class="modal-title" id="exampleModalLongTitle"><?php echo e(translate('Send_Message_to_vendor')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="<?php echo e(route('messages')); ?>" method="post" id="shop-view-chat-form">
                        <?php echo csrf_field(); ?>
                        <input value="<?php echo e($shopInfoArray['id'] != 0 ? $shopInfoArray['id'] : 0); ?>" name="vendor_id" hidden>
                        <textarea name="message" class="form-control min-height-100px max-height-200px" required
                                  placeholder="<?php echo e(translate('Write_here')); ?>..."></textarea>
                        <br>
                        <div class="justify-content-end gap-2 d-flex flex-wrap">
                            <a href="<?php echo e(route('chat', ['type' => 'vendor'])); ?>"
                               class="btn btn-soft-primary bg--secondary border">
                                <?php echo e(translate('go_to_chatbox')); ?>

                            </a>
                            <button class="btn btn--primary text-white">
                                <?php echo e(translate('send')); ?>

                            </button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>

    <span id="products-search-data-backup"
          data-page="<?php echo e(request('page') ?? 1); ?>"
          data-url="<?php echo e(route('shopView', ['id' => ($shopInfoArray['id'] != 0 ? $shopInfoArray['id'] : 0)])); ?>"
          data-brand="<?php echo e($data['brand_id'] ?? ''); ?>"
          data-category="<?php echo e($data['category_id'] ?? ''); ?>"
          data-name="<?php echo e(request('search') ?? request('name')); ?>"
          data-from="<?php echo e(request('data_from')); ?>"
          data-offer-type = "<?php echo e(request('offer_type')); ?>"
          data-product-check="clearance_sale"
          data-sort="<?php echo e(request('sort_by')); ?>"
          data-product-type="<?php echo e(request('product_type') ?? 'all'); ?>"
          data-message="<?php echo e(translate('items_found')); ?>"
          data-publishing-house-id="<?php echo e(request('publishing_house_id')); ?>"
          data-author-id="<?php echo e(request('author_id')); ?>"
          data-offer="<?php echo e(request('offer_type') ?? ''); ?>"
    ></span>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(theme_asset(path: 'public/assets/front-end/js/product-list-filter.js')); ?>"></script>
    <script>
        $('.close-icon').on('click', function () {
            $("#shop-sidebar").toggleClass("show active");
        });
    </script>
<?php $__env->stopPush(); ?>



<?php echo $__env->make('layouts.front-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\Crowdfunding1\E-Africal Mall org\resources\themes\default/web-views/seller-view/shopview.blade.php ENDPATH**/ ?>